/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements au,
Runnable,
sm,
th {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private final bdq l;
    private final tg m = new tg("server", this, MinecraftServer.aw());
    private final File n;
    private final List<mu> o = Lists.newArrayList();
    public final at b;
    public final qi c = new qi();
    private final nw p;
    private final ls q = new ls();
    private final Random r = new Random();
    private final qv s;
    private int u = -1;
    public nl[] d;
    private oi v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    private String F;
    private int G;
    private int H;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair I;
    private String J;
    private String K;
    private String L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final oe Y;
    private long Z;
    public final Queue<FutureTask<?>> j = Queues.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.aw();
    private boolean ac;

    public MinecraftServer(File file, Proxy proxy, qv qv2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, oe oe2) {
        this.e = proxy;
        this.V = yggdrasilAuthenticationService;
        this.W = minecraftSessionService;
        this.X = gameProfileRepository;
        this.Y = oe2;
        this.n = file;
        this.p = new nw(this);
        this.b = this.i();
        this.l = new bdj(file, qv2);
        this.s = qv2;
    }

    public cl i() {
        return new cl(this);
    }

    public abstract boolean j() throws IOException;

    public void a(String string) {
        if (this.W().b(string)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.W().a(string, new qj(){
                private long b = MinecraftServer.aw();

                @Override
                public void a(String string) {
                }

                @Override
                public void b(String string) {
                }

                @Override
                public void a(int n2) {
                    if (MinecraftServer.aw() - this.b >= 1000L) {
                        this.b = MinecraftServer.aw();
                        k.info("Converting... {}%", new Object[]{n2});
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(String string) {
                }
            });
        }
    }

    protected synchronized void b(String string) {
        this.S = string;
    }

    @Nullable
    public synchronized String k() {
        return this.S;
    }

    public void a(String string, String string2, long l22, alm alm2, String string3) {
        alk \u26033;
        this.a(string);
        this.b("menu.loadingLevel");
        this.d = new nl[3];
        this.i = new long[this.d.length][100];
        bdo bdo2 = this.l.a(string, true);
        this.a(this.S(), bdo2);
        bdn \u26032 = bdo2.d();
        if (\u26032 == null) {
            if (this.V()) {
                \u26033 = nf.a;
            } else {
                long l22;
                \u26033 = new alk(l22, this.n(), this.m(), this.p(), alm2);
                \u26033.a(string3);
                if (this.N) {
                    \u26033.a();
                }
            }
            \u26032 = new bdn(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new alk(\u26032);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            \u2603 = 0;
            if (i2 == 1) {
                \u2603 = -1;
            }
            if (i2 == 2) {
                \u2603 = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.V() ? (nl)new nf(this, bdo2, \u26032, \u2603, this.c).b() : (nl)new nl(this, bdo2, \u26032, \u2603, this.c).b();
                this.d[i2].a(\u26033);
            } else {
                this.d[i2] = (nl)new nh(this, bdo2, \u2603, this.d[0], this.c).b();
            }
            this.d[i2].a(new nm(this, this.d[i2]));
            if (this.R()) continue;
            this.d[i2].U().a(this.n());
        }
        this.v.a(this.d);
        this.a(this.o());
        this.l();
    }

    public void l() {
        int n2 = 16;
        \u2603 = 4;
        \u2603 = 192;
        \u2603 = 625;
        \u2603 = 0;
        this.b("menu.generatingTerrain");
        boolean \u26032 = false;
        k.info("Preparing start region for level 0");
        nl \u26033 = this.d[0];
        dx \u26034 = \u26033.S();
        long \u26035 = MinecraftServer.aw();
        for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
            for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
                long l2 = MinecraftServer.aw();
                if (l2 - \u26035 > 1000L) {
                    this.a_("Preparing spawn area", \u2603 * 100 / 625);
                    \u26035 = l2;
                }
                ++\u2603;
                \u26033.r().c(\u26034.p() + \u2603 >> 4, \u26034.r() + \u2603 >> 4);
            }
        }
        this.t();
    }

    public void a(String string, bdo bdo2) {
        File file = new File(bdo2.b(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a_("level://" + URLEncoder.encode(string, Charsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                k.warn("Something went wrong url encoding {}", new Object[]{string});
            }
        }
    }

    public abstract boolean m();

    public abstract alf n();

    public abstract su o();

    public abstract boolean p();

    public abstract int q();

    public abstract boolean r();

    public abstract boolean s();

    protected void a_(String string, int n2) {
        this.f = string;
        this.g = n2;
        k.info("{}: {}%", new Object[]{string, n2});
    }

    protected void t() {
        this.f = null;
        this.g = 0;
    }

    public void a(boolean bl2) {
        for (nl nl2 : this.d) {
            if (nl2 == null) continue;
            if (!bl2) {
                k.info("Saving chunks for level '{}'/{}", new Object[]{nl2.U().j(), nl2.s.q().b()});
            }
            try {
                nl2.a(true, null);
            }
            catch (ali ali2) {
                k.warn(ali2.getMessage());
            }
        }
    }

    public void u() {
        k.info("Stopping server");
        if (this.an() != null) {
            this.an().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            k.info("Saving worlds");
            for (nl nl2 : this.d) {
                if (nl2 == null) continue;
                nl2.b = false;
            }
            this.a(false);
            for (nl nl2 : this.d) {
                if (nl2 == null) continue;
                nl2.s();
            }
        }
        if (this.m.d()) {
            this.m.e();
        }
    }

    public boolean w() {
        return this.w;
    }

    public void x() {
        this.w = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.j()) {
                this.ab = MinecraftServer.aw();
                long l2 = 0L;
                this.q.a(new gq(this.F));
                this.q.a(new ls.c("17w13a", 318));
                this.a(this.q);
                while (this.w) {
                    \u2603 = MinecraftServer.aw();
                    \u2603 = \u2603 - this.ab;
                    if (\u2603 > 2000L && this.ab - this.R >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{\u2603, \u2603 / 50L});
                        \u2603 = 2000L;
                        this.R = this.ab;
                    }
                    if (\u2603 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        \u2603 = 0L;
                    }
                    l2 += \u2603;
                    this.ab = \u2603;
                    if (this.d[0].g()) {
                        this.C();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.C();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.Q = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            k.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof f ? this.b(((f)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.A(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(\u26032)) {
                k.error("This crash report has been saved to: {}", new Object[]{\u26032.getAbsolutePath()});
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.x = true;
                this.u();
            }
            catch (Throwable \u26033) {
                k.error("Exception stopping the server", \u26033);
            }
            finally {
                this.B();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ls ls2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.W().b(this.S(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf \u26032 = Base64.encode((ByteBuf)byteBuf);
                ls2.a("data:image/png;base64," + \u26032.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean y() {
        this.ac = this.ac || this.z().isFile();
        return this.ac;
    }

    public File z() {
        return this.W().b(this.S(), "icon.png");
    }

    public File A() {
        return new File(".");
    }

    public void a(b b2) {
    }

    public void B() {
    }

    public void C() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.D();
        if (l2 - this.Z >= 5000000000L) {
            this.Z = l2;
            this.q.a(new ls.a(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int \u26032 = qh.a(this.r, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.v().get(\u26032 + i2).cV();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - l2;
        this.c.b();
        this.c.a("snooper");
        if (!this.m.d() && this.y > 100) {
            this.m.a();
        }
        if (this.y % 6000 == 0) {
            this.m.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void D() {
        int n2;
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                h.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        for (n2 = 0; n2 < this.d.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.E()) {
                nl nl2 = this.d[n2];
                this.c.a(nl2.U().j());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new jo(nl2.Q(), nl2.R(), nl2.V().b("doDaylightCycle")), nl2.s.q().a());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    nl2.d();
                }
                catch (Throwable \u26032) {
                    b b2 = b.a(\u26032, "Exception ticking world");
                    nl2.a(b2);
                    throw new f(b2);
                }
                try {
                    nl2.k();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    nl2.a(b3);
                    throw new f(b3);
                }
                this.c.b();
                this.c.a("tracker");
                nl2.v().a();
                this.c.b();
                this.c.b();
            }
            this.i[n2][this.y % 100] = System.nanoTime() - l2;
        }
        this.c.c("connection");
        this.an().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (n2 = 0; n2 < this.o.size(); ++n2) {
            this.o.get(n2).G_();
        }
        this.c.b();
    }

    public boolean E() {
        return true;
    }

    public void F() {
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String string) {
        return new File(this.A(), string);
    }

    public void f(String string) {
        k.warn(string);
    }

    public nl a(int n2) {
        if (n2 == -1) {
            return this.d[1];
        }
        if (n2 == 1) {
            return this.d[2];
        }
        return this.d[0];
    }

    public String G() {
        return "17w13a";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new d<String>(){

            public String a() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        });
        if (this.v != null) {
            b2.g().a("Player Count", new d<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        return b2;
    }

    public List<String> a(au au2, String string2, @Nullable dx dx2, boolean bl22) {
        boolean bl22;
        String string2;
        ArrayList arrayList = Lists.newArrayList();
        boolean \u26032 = string2.startsWith("/");
        if (\u26032) {
            string2 = string2.substring(1);
        }
        if (\u26032 || bl22) {
            \u2603 = !string2.contains(" ");
            List<String> list = this.b.a(au2, string2, dx2);
            if (!list.isEmpty()) {
                for (String string3 : list) {
                    if (\u2603) {
                        arrayList.add("/" + string3);
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
        String[] \u26033 = string2.split(" ", -1);
        \u2603 = \u26033[\u26033.length - 1];
        for (String string4 : this.v.f()) {
            if (!aq.a(\u2603, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean M() {
        return this.n != null;
    }

    @Override
    public String h_() {
        return "Server";
    }

    @Override
    public void a(gk gk2) {
        k.info(gk2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public at N() {
        return this.b;
    }

    public KeyPair O() {
        return this.I;
    }

    public String Q() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public boolean R() {
        return this.J != null;
    }

    public String S() {
        return this.K;
    }

    public void j(String string) {
        this.K = string;
    }

    public void k(String string) {
        this.L = string;
    }

    public String T() {
        return this.L;
    }

    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(su su2) {
        for (nl nl2 : this.d) {
            if (nl2 == null) continue;
            if (nl2.U().s()) {
                nl2.U().a(su.d);
                nl2.a(true, true);
                continue;
            }
            if (this.R()) {
                nl2.U().a(su2);
                nl2.a(nl2.af() != su.a, true);
                continue;
            }
            nl2.U().a(su2);
            nl2.a(this.U(), this.B);
        }
    }

    public boolean U() {
        return true;
    }

    public boolean V() {
        return this.M;
    }

    public void b(boolean bl2) {
        this.M = bl2;
    }

    public void c(boolean bl2) {
        this.N = bl2;
    }

    public bdq W() {
        return this.l;
    }

    public String X() {
        return this.O;
    }

    public String Y() {
        return this.P;
    }

    public void a_(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(tg tg22) {
        tg tg22;
        tg22.a("whitelist_enabled", false);
        tg22.a("whitelist_count", 0);
        if (this.v != null) {
            tg22.a("players_current", this.H());
            tg22.a("players_max", this.I());
            tg22.a("players_seen", this.v.q().length);
        }
        tg22.a("uses_auth", this.z);
        tg22.a("gui_state", this.ap() ? "enabled" : "disabled");
        tg22.a("run_time", (MinecraftServer.aw() - tg22.g()) / 60L * 1000L);
        tg22.a("avg_tick_ms", (int)(qh.a(this.h) * 1.0E-6));
        int n2 = 0;
        if (this.d != null) {
            for (nl nl2 : this.d) {
                if (nl2 == null) continue;
                bdn bdn2 = nl2.U();
                tg22.a("world[" + n2 + "][dimension]", nl2.s.q().a());
                tg22.a("world[" + n2 + "][mode]", (Object)bdn2.q());
                tg22.a("world[" + n2 + "][difficulty]", (Object)nl2.af());
                tg22.a("world[" + n2 + "][hardcore]", bdn2.s());
                tg22.a("world[" + n2 + "][generator_name]", bdn2.t().a());
                tg22.a("world[" + n2 + "][generator_version]", bdn2.t().d());
                tg22.a("world[" + n2 + "][height]", this.G);
                tg22.a("world[" + n2 + "][chunks_loaded]", nl2.r().g());
                ++n2;
            }
        }
        tg22.a("worlds", n2);
    }

    @Override
    public void b(tg tg2) {
        tg2.b("singleplayer", this.R());
        tg2.b("server_brand", this.getServerModName());
        tg2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        tg2.b("dedicated", this.aa());
    }

    @Override
    public boolean Z() {
        return true;
    }

    public abstract boolean aa();

    public boolean ab() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean ac() {
        return this.A;
    }

    public boolean ad() {
        return this.B;
    }

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean ae() {
        return this.C;
    }

    public abstract boolean af();

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean ag() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public boolean ah() {
        return this.E;
    }

    public void i(boolean bl2) {
        this.E = bl2;
    }

    public abstract boolean ai();

    public String aj() {
        return this.F;
    }

    public void l(String string) {
        this.F = string;
    }

    public int ak() {
        return this.G;
    }

    public void c(int n2) {
        this.G = n2;
    }

    public boolean al() {
        return this.x;
    }

    public oi am() {
        return this.v;
    }

    public void a(oi oi2) {
        this.v = oi2;
    }

    public void a(alf alf2) {
        for (nl nl2 : this.d) {
            nl2.U().a(alf2);
        }
    }

    public nw an() {
        return this.p;
    }

    public boolean ao() {
        return this.Q;
    }

    public boolean ap() {
        return false;
    }

    public abstract String a(alf var1, boolean var2);

    public int aq() {
        return this.y;
    }

    public void ar() {
        this.T = true;
    }

    public tg as() {
        return this.m;
    }

    @Override
    public dx c() {
        return dx.a;
    }

    @Override
    public bfo d() {
        return bfo.a;
    }

    @Override
    public alh e() {
        return this.d[0];
    }

    @Override
    public ub f() {
        return null;
    }

    public boolean a(alh alh2, dx dx2, act act2) {
        return false;
    }

    public boolean au() {
        return this.U;
    }

    public Proxy av() {
        return this.e;
    }

    public static long aw() {
        return System.currentTimeMillis();
    }

    public int ax() {
        return this.H;
    }

    public void d(int n2) {
        this.H = n2;
    }

    @Override
    public gk i_() {
        return new gq(this.h_());
    }

    public MinecraftSessionService az() {
        return this.W;
    }

    public GameProfileRepository aA() {
        return this.X;
    }

    public oe aB() {
        return this.Y;
    }

    public ls aC() {
        return this.q;
    }

    public void aD() {
        this.Z = 0L;
    }

    @Nullable
    public ub a(UUID uUID) {
        for (nl nl2 : this.d) {
            if (nl2 == null || (\u2603 = nl2.a(uUID)) == null) continue;
            return \u2603;
        }
        return null;
    }

    @Override
    public boolean g() {
        return this.d[0].V().b("sendCommandFeedback");
    }

    @Override
    public void a(av.a a2, int n2) {
    }

    @Override
    public MinecraftServer C_() {
        return this;
    }

    public int aE() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.aF() && !this.al()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aF() {
        return Thread.currentThread() == this.aa;
    }

    public int aG() {
        return 256;
    }

    public qv aJ() {
        return this.s;
    }

    public int a(@Nullable nl nl2) {
        if (nl2 != null) {
            return nl2.V().c("spawnRadius");
        }
        return 10;
    }

    public mq aK() {
        return this.d[0].z();
    }
}

